function [A,B] = bfor_endogenous_ms_solver_matrices_x(nderivs,ns)
% 
% Returns the matrices A and B for solving the first order derivative
%   with respect to xlat
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  ns       = number of regimes
%  
%  OUTPUTS
%   A       = {ns x ns) cell of derivative coefficients for solving the
%               system
%   B       = {ns x ns) cell of derivative coefficients for solving the 
%               system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

A = cell(ns,ns);
B = cell(ns,ns);
        
for s = 1:ns
    for sp = 1:ns         
        % Derivatives 
        dfyp    = nderivs.dfyp{sp,s};
        dfy     = nderivs.dfy{sp,s};
        dfx     = nderivs.dfx{sp,s};
        dfxlag	= nderivs.dfxlag{sp,s};
                
        % Construct Matrices
        A{sp,s} = [dfx dfyp];
        B{sp,s} = [dfxlag dfy];
    end
end
